import { type NextRequest, NextResponse } from "next/server"
import { neon } from "@neondatabase/serverless"

const sql = neon(process.env.DATABASE_URL!)

export async function PATCH(request: NextRequest, { params }: { params: { id: string } }) {
  try {
    const { status } = await request.json()
    const userId = Number.parseInt(params.id)

    // Convert status string to boolean for is_active field
    const isActive = status === "active"

    const result = await sql`
      UPDATE users 
      SET is_active = ${isActive}, updated_at = NOW()
      WHERE id = ${userId}
      RETURNING id, name, email, is_active, is_master, created_at
    `

    if (result.length === 0) {
      return NextResponse.json(
        {
          success: false,
          message: "Usuário não encontrado",
        },
        { status: 404 },
      )
    }

    return NextResponse.json({
      success: true,
      user: result[0],
    })
  } catch (error) {
    console.error("Update user error:", error)
    return NextResponse.json(
      {
        success: false,
        message: "Erro interno do servidor",
      },
      { status: 500 },
    )
  }
}

export async function PUT(request: NextRequest, { params }: { params: { id: string } }) {
  try {
    const { name, email } = await request.json()
    const userId = Number.parseInt(params.id)

    // Check if email is already taken by another user
    const existingUser = await sql`
      SELECT id FROM users WHERE email = ${email} AND id != ${userId}
    `

    if (existingUser.length > 0) {
      return NextResponse.json(
        {
          success: false,
          message: "Este email já está sendo usado por outro usuário",
        },
        { status: 400 },
      )
    }

    const result = await sql`
      UPDATE users 
      SET name = ${name}, email = ${email}, updated_at = NOW()
      WHERE id = ${userId}
      RETURNING id, name, email, is_active, is_master, created_at
    `

    if (result.length === 0) {
      return NextResponse.json(
        {
          success: false,
          message: "Usuário não encontrado",
        },
        { status: 404 },
      )
    }

    return NextResponse.json({
      success: true,
      user: result[0],
    })
  } catch (error) {
    console.error("Update user error:", error)
    return NextResponse.json(
      {
        success: false,
        message: "Erro interno do servidor",
      },
      { status: 500 },
    )
  }
}
